//|||||||||||||||||||||||||||||||||||||||||||||||

#include "ExampleApp.hpp"

#include "MenuState.hpp"
#include "GameState.hpp"
#include "PauseState.hpp"

//|||||||||||||||||||||||||||||||||||||||||||||||

ExampleApp::ExampleApp()
{
	m_pAppStateManager = 0;
}

//|||||||||||||||||||||||||||||||||||||||||||||||

ExampleApp::~ExampleApp()
{
	delete m_pAppStateManager;
    delete OgreFramework::getSingletonPtr();
}

//|||||||||||||||||||||||||||||||||||||||||||||||

void ExampleApp::startExample()
{
	new OgreFramework();
	if(!OgreFramework::getSingletonPtr()->initOgre("Example", 0, 0))
		return;

	OgreFramework::getSingletonPtr()->m_pLog->logMessage("Example initialized!");

	m_pAppStateManager = new AppStateManager();

	MenuState::create(m_pAppStateManager, "MenuState");
	GameState::create(m_pAppStateManager, "GameState");
    PauseState::create(m_pAppStateManager, "PauseState");

	m_pAppStateManager->start(m_pAppStateManager->findByName("MenuState"));
}

//|||||||||||||||||||||||||||||||||||||||||||||||
