/*********************************************************************
 * Módulo 2. Curso de Experto en Desarrollo de Videojuegos
 * Autor: Carlos González Morcillo     Carlos.Gonzalez@uclm.es
 *
 * You can redistribute and/or modify this file under the terms of the
 * GNU General Public License ad published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * and later version. See <http://www.gnu.org/licenses/>.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.  
 *********************************************************************/

#include <ExampleApplication.h>

class SimpleExample : public ExampleApplication {
  public : void createScene() {
    SceneNode* node1 = mSceneMgr->createSceneNode("Node1");
    Entity *ent1 = mSceneMgr->createEntity("ent1", "cuboejes.mesh");
    node1->attachObject(ent1);
    mSceneMgr->getRootSceneNode()->addChild(node1);
    node1->setPosition(0,0,480);
    node1->yaw(Degree(-45));   // Por defecto es Node::TS_LOCAL
    node1->pitch(Degree(45));  // Por defecto es Node::TS_LOCAL
    
    SceneNode* node2 = mSceneMgr->createSceneNode("Node2");
    Entity *ent2 = mSceneMgr->createEntity("ent2", "cuboejes.mesh");
    node2->attachObject(ent2);
    node1->addChild(node2);
    node2->yaw(Degree(-90));  // Por defecto es Node::TS_LOCAL
    node2->translate(5,0,0);  // Por defecto es Node::TS_PARENT
    
    SceneNode* node3 = mSceneMgr->createSceneNode("Node3");
    Entity *ent3 = mSceneMgr->createEntity("ent3", "cuboejes.mesh");
    node3->attachObject(ent3);
    node1->addChild(node3);
    node3->yaw(Degree(-90));  // Por defecto es Node::TS_LOCAL
    node3->translate(5,0,0, Node::TS_LOCAL);  // Cambiamos a LOCAL!
  }
};

int main(void) {
  SimpleExample example;
  example.go();
  
  return 0;
}
