/********************************************************************
 * Módulo 2. Curso de Experto en Desarrollo de Videojuegos Autor:
 * Carlos González Morcillo Carlos.Gonzalez@uclm.es
 *
 * You can redistribute and/or modify this file under the terms of 
 * the GNU General Public License ad published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * and later version. See <http://www.gnu.org/licenses/>.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.  
 *******************************************************************/

#include <iostream>
#include <Ogre.h>
using namespace std;
using namespace Ogre;

int main(void) {
  cout << "Ejemplo de algunas clases de Math en OGRE" << endl;
  cout << "-----------------------------------------" << endl;

  Vector3 v1(1.0, 0.0, 0.0);
  Vector3 v2(0.0, 2.0, 0.0);
  Quaternion p(0.707107, 0.0, 0.0, 0.707107);
  Quaternion q(Degree(90), Vector3(0.0, 1.0, 0.0));

  cout << " Vector V1 = " << v1 << endl;
  cout << " Vector V2 = " << v2 << endl;
  cout << " Cuaternio P = " << p << endl;
  cout << " Cuaternio Q = " << q << endl;
  
  cout << "--- Algunos operadores de Vectores ------" << endl;
  cout << " Suma: V1 + V2 = " << v1 + v2 << endl;
  cout << " Producto por escalar: V1 * 7.0 = " << v1*7.0 << endl;
  cout << " Producto escalar: V1 · V2 = " << v1.dotProduct(v2) << endl;
  cout << " Producto vectorial: V1 x V2 = " << v1.crossProduct(v2) << endl;
  cout << " Módulo: |V1| = " << v1.length() << endl;
  cout << " Normalizar: V2n = " << v2.normalisedCopy() << endl;
  cout << " Ángulo entre V1 y V2 = " << v1.angleBetween(v2).valueDegrees() << endl;
  cout << "--- Algunos operadores de Cuaternios ----" << endl;
  cout << " Suma: P + Q = " << p + q << endl;
  cout << " Producto: P * Q = " << p * q << endl;
  cout << " Producto escalar: P · Q = " << p.Dot(q) << endl;
  cout << " SLERP(p,q,0.5) = "<< Quaternion::Slerp(0.5, p, q) << endl;

  return 0;
}
