#include <GL/glut.h>
#include <GL/glu.h>
#include <GL/gl.h> 
#include <stdio.h>

// GLUT llama a esta funcion cuando hay que redibujar la ventana
// ------------------------------------------------------------- 
void display() { 
    glClear( GL_COLOR_BUFFER_BIT ); 
    glEnable(GL_DEPTH_TEST);
    glLoadIdentity(); 
    glTranslatef( 0.f, 0.f, -4.f ); 

    glBegin(GL_QUADS);
    glColor3f(1.0, 0.0, 0.0);
    glVertex3f(1.0, 1.0, 0.0);
    glColor3f(0.0, 1.0, 0.0);
    glVertex3f(1.0, -1.0, 0.0);
    glColor3f(0.0, 0.0, 1.0);
    glVertex3f(-1.0, -1.0, 0.0);
    glColor3f(1.0, 1.0, 1.0);
    glVertex3f(-1.0, 1.0, 0.0);
    glEnd();
    glDisable(GL_DEPTH_TEST);

    glutSwapBuffers();      
} 

// GLUT llama a esta funcion cuando se cambia el tamao de la ventana 
// ------------------------------------------------------------------
void resize(int w, int h) 
{ 
    // Viewport para dibujar en toda la ventana 
    glViewport( 0, 0, w, h ); 

    // Actualizamos en la matriz de proyeccin el ratio ancho/alto 
    glMatrixMode( GL_PROJECTION ); 
    glLoadIdentity(); 
    gluPerspective( 50., (double)w/(double)h, 1., 10. ); 

    // Volvemos al modo Vista de Modelo 
    glMatrixMode( GL_MODELVIEW ); 
} 

// Inicializacion del estado de OpenGL
// ------------------------------------
void init() 
{ 
  glEnable (GL_DEPTH_TEST);
} 

int main( int argc, char** argv ) 
{ 
    glutInit( &argc, argv ); 

    glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE ); 
    glutInitWindowSize( 400, 400 ); 
    glutCreateWindow( "Hola Mundo" ); 
    init();  
    // Registro de funciones de callback
    glutDisplayFunc(display); 
    glutReshapeFunc(resize); 

    glutMainLoop();  
    return 0; 
} 
