#include <Ogre.h>
#include <OIS/OIS.h>
#include <btBulletDynamicsCommon.h>

using namespace Ogre;

class MyFrameListener : public Ogre::FrameListener {
private:
  Ogre::Camera* _camera;
  Ogre::OverlayManager* _overlayManager;
  Ogre::SceneManager *_sceneManager;

  OIS::InputManager* _inputManager;
  OIS::Keyboard* _keyboard;
  OIS::Mouse* _mouse;

  btBroadphaseInterface* _broadphase;
  btDefaultCollisionConfiguration* _collisionConf;
  btCollisionDispatcher* _dispatcher;
  btSequentialImpulseConstraintSolver* _solver;
  btDiscreteDynamicsWorld* _world;

  btCollisionShape* _groundShape;  btCollisionShape* _fallShape;
  btRigidBody* _groundRigidBody;  btRigidBody* _fallRigidBody;
  
  void CreateInitialWorld();

public:
  MyFrameListener(Ogre::RenderWindow* win, Ogre::Camera* cam, 
		  Ogre::OverlayManager* om, Ogre::SceneManager* sm);
  ~MyFrameListener();
  bool frameStarted(const Ogre::FrameEvent& evt);  
  bool frameEnded(const Ogre::FrameEvent& evt);  
};
