/*********************************************************************
 * Módulo 2. Curso de Experto en Desarrollo de Videojuegos
 * Autor: Carlos González Morcillo     Carlos.Gonzalez@uclm.es
 *
 * You can redistribute and/or modify this file under the terms of the
 * GNU General Public License ad published by the Free Software
 * Foundation, either version 3 of the License, or (at your option)
 * and later version. See <http://www.gnu.org/licenses/>.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.  
 *********************************************************************/
#include "MyFrameListener.h"

MyFrameListener::MyFrameListener(Ogre::RenderWindow* win, 
				 Ogre::Camera* cam, 
				 Ogre::SceneNode *node, 
				 Ogre::OverlayManager *om) {
  OIS::ParamList param;
  size_t windowHandle;  std::ostringstream wHandleStr;

  _camera = cam;  _node = node; _overlayManager = om;
  nmat = 1;  // Inicialmente utilizamos el material 1
  
  win->getCustomAttribute("WINDOW", &windowHandle);
  wHandleStr << windowHandle;
  param.insert(std::make_pair("WINDOW", wHandleStr.str()));
  
  _inputManager = OIS::InputManager::createInputSystem(param);
  _keyboard = static_cast<OIS::Keyboard*>
    (_inputManager->createInputObject(OIS::OISKeyboard, false));
}

MyFrameListener::~MyFrameListener() {
  _inputManager->destroyInputObject(_keyboard);
  OIS::InputManager::destroyInputSystem(_inputManager);
}

bool MyFrameListener::frameStarted(const Ogre::FrameEvent& evt) {
  Ogre::Real r = 0;
  Ogre::Real deltaT = evt.timeSinceLastFrame;
  int fps = 1.0 / deltaT;

  _keyboard->capture();
  Entity *ent = static_cast <Entity *> (_node->getAttachedObject("Esfera"));
  if(_keyboard->isKeyDown(OIS::KC_ESCAPE)) return false;
  if(_keyboard->isKeyDown(OIS::KC_1)) nmat = 1;
  if(_keyboard->isKeyDown(OIS::KC_2)) nmat = 2;
  if(_keyboard->isKeyDown(OIS::KC_3)) nmat = 3;
  if(_keyboard->isKeyDown(OIS::KC_4)) nmat = 4;
  if(_keyboard->isKeyDown(OIS::KC_5)) nmat = 5;
  if(_keyboard->isKeyDown(OIS::KC_5)) nmat = 6;
  if(_keyboard->isKeyDown(OIS::KC_5)) nmat = 7;
  if(_keyboard->isKeyDown(OIS::KC_5)) nmat = 8;

  if(_keyboard->isKeyDown(OIS::KC_R)) r+=180;
  _node->yaw(Ogre::Degree(r * deltaT));

  std::stringstream saux;  saux << "Material" << nmat;
  ent->setMaterialName(saux.str());
  
  Ogre::OverlayElement *oe;
  oe = _overlayManager->getOverlayElement("fpsInfo");
  oe->setCaption(Ogre::StringConverter::toString(fps));
  oe = _overlayManager->getOverlayElement("materialInfo");
  oe->setCaption(saux.str());


  return true;
}
